/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SoftSynthesizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Track;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public final class SoftMidiAudioFileReader
extends AudioFileReader {
    public static final AudioFileFormat.Type MIDI = new AudioFileFormat.Type("MIDI", "mid");
    private static AudioFormat format = new AudioFormat(44100.0f, 16, 2, true, false);

    public AudioFileFormat getAudioFileFormat(Sequence sequence) throws UnsupportedAudioFileException, IOException {
        long l = sequence.getMicrosecondLength() / 1000000L;
        long l2 = (long)(format.getFrameRate() * (float)(l + 4L));
        return new AudioFileFormat(MIDI, format, (int)l2);
    }

    public AudioInputStream getAudioInputStream(Sequence sequence) throws UnsupportedAudioFileException, IOException {
        Receiver receiver;
        AudioInputStream audioInputStream;
        SoftSynthesizer softSynthesizer = new SoftSynthesizer();
        try {
            audioInputStream = softSynthesizer.openStream(format, null);
            receiver = softSynthesizer.getReceiver();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            throw new IOException(midiUnavailableException.toString());
        }
        float f = sequence.getDivisionType();
        Track[] trackArray = sequence.getTracks();
        int[] nArray = new int[trackArray.length];
        int n = 500000;
        int n2 = sequence.getResolution();
        long l = 0L;
        long l2 = 0L;
        while (true) {
            Object object;
            Object object2;
            MidiEvent midiEvent = null;
            int n3 = -1;
            for (int i = 0; i < trackArray.length; ++i) {
                int n4 = nArray[i];
                object2 = trackArray[i];
                if (n4 >= ((Track)object2).size()) continue;
                object = ((Track)object2).get(n4);
                if (midiEvent != null && ((MidiEvent)object).getTick() >= midiEvent.getTick()) continue;
                midiEvent = object;
                n3 = i;
            }
            if (n3 == -1) break;
            int n5 = n3;
            nArray[n5] = nArray[n5] + 1;
            long l3 = midiEvent.getTick();
            l2 = f == 0.0f ? (l2 += (l3 - l) * (long)n / (long)n2) : (long)((double)l3 * 1000000.0 * (double)f / (double)n2);
            l = l3;
            object2 = midiEvent.getMessage();
            if (object2 instanceof MetaMessage) {
                if (f != 0.0f || ((MetaMessage)object2).getType() != 81) continue;
                object = ((MetaMessage)object2).getData();
                if (((Object)object).length < 3) {
                    throw new UnsupportedAudioFileException();
                }
                n = (object[0] & 0xFF) << 16 | (object[1] & 0xFF) << 8 | object[2] & 0xFF;
                continue;
            }
            receiver.send((MidiMessage)object2, l2);
        }
        long l4 = l2 / 1000000L;
        long l5 = (long)(audioInputStream.getFormat().getFrameRate() * (float)(l4 + 4L));
        audioInputStream = new AudioInputStream(audioInputStream, audioInputStream.getFormat(), l5);
        return audioInputStream;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Sequence sequence;
        inputStream.mark(200);
        try {
            sequence = MidiSystem.getSequence(inputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            inputStream.reset();
            throw new UnsupportedAudioFileException();
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioInputStream(sequence);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        Sequence sequence;
        try {
            sequence = MidiSystem.getSequence(uRL);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException iOException) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioFileFormat(sequence);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        Sequence sequence;
        try {
            sequence = MidiSystem.getSequence(file);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException iOException) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioFileFormat(sequence);
    }

    @Override
    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        Sequence sequence;
        try {
            sequence = MidiSystem.getSequence(uRL);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException iOException) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioInputStream(sequence);
    }

    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        Sequence sequence;
        if (!file.getName().toLowerCase().endsWith(".mid")) {
            throw new UnsupportedAudioFileException();
        }
        try {
            sequence = MidiSystem.getSequence(file);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw new UnsupportedAudioFileException();
        }
        catch (IOException iOException) {
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioInputStream(sequence);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        Sequence sequence;
        inputStream.mark(200);
        try {
            sequence = MidiSystem.getSequence(inputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            inputStream.reset();
            throw new UnsupportedAudioFileException();
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw new UnsupportedAudioFileException();
        }
        return this.getAudioFileFormat(sequence);
    }
}

