/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart.model;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetFilterDescription;
import com.jrockit.mc.flightrecorder.ui.components.EventTypeAcceptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.model.XAxisDescriptor;

public class FLRDescriptorToolkit {
    private static final String FILTER_EXPRESSION = "filterExpression";

    public static EventTypeAcceptor createAcceptor(IServiceLocator serviceLocator, DataSeriesDescriptor descriptor) {
        return new EventTypeAcceptor(serviceLocator, FLRDescriptorToolkit.getEventTypeRepository(descriptor));
    }

    public static boolean isUserFilterConstrained(DataSeriesDescriptor descriptor) {
        return FLRDescriptorToolkit.getEventTypeRepository(descriptor).getUserFilterConstrained();
    }

    public static EventTypeDescriptorRepository getEventTypeRepository(DataSeriesDescriptor descriptor) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        return (EventTypeDescriptorRepository)setting.getChildObject("eventTypes", EventTypeDescriptorRepository.class);
    }

    public static void setEventTypeRepository(DataSeriesDescriptor descriptor, EventTypeDescriptorRepository typeRepository) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        setting.setChildObject("eventTypes", (Object)typeRepository);
    }

    public static String getYDataSource(DataSeriesDescriptor descriptor) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        return (String)setting.getChildObject("attributeIdentifier", String.class);
    }

    public static void setYDataSource(DataSeriesDescriptor descriptor, String identifier) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        setting.setChildObject("attributeIdentifier", (Object)identifier);
    }

    public static String getXDataSource(XAxisDescriptor descriptor) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        String s = (String)setting.getChildObject("attributeIdentifier", String.class);
        if (s.length() == 0) {
            s = "(endTime)";
        }
        return s;
    }

    public static void setXDataSource(XAxisDescriptor descriptor, String identifier) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        setting.setChildObject("attributeIdentifier", (Object)identifier);
    }

    public static OperativeSetFilterDescription getOperativeSet(DataSeriesDescriptor descriptor) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        return OperativeSetFilterDescription.getWithKey((String)setting.getChildObject("operativeSet", String.class));
    }

    public static void setOperativeSet(DataSeriesDescriptor descriptor, boolean operativeSetFilterEnabled) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        setting.setChildObject("operativeSet", (Object)operativeSetFilterEnabled);
    }

    public static String getFilterExpression(DataSeriesDescriptor descriptor) {
        Setting setting = PersistenceToolkit.getSetting((Object)descriptor);
        return (String)setting.getChildObject(FILTER_EXPRESSION, String.class);
    }

    public static boolean hasFilterExpression(DataSeriesDescriptor descriptor) {
        return FLRDescriptorToolkit.getFilterExpression(descriptor).length() > 0;
    }
}

