/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.io.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.MouseUtils;
import org.openide.awt.TabbedPaneFactory;
import org.openide.awt.ToolbarWithOverflow;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOContainer;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IOWindow
implements IOContainer.Provider {
    private static IOWindowImpl impl;

    IOWindowImpl impl() {
        if (impl == null) {
            impl = IOWindowImpl.findDefault();
        }
        return impl;
    }

    public void add(JComponent jComponent, IOContainer.CallBacks callBacks) {
        this.impl().addTab(jComponent, callBacks);
    }

    public JComponent getSelected() {
        return this.impl().getSelectedTab();
    }

    public boolean isActivated() {
        return this.impl().isActivated();
    }

    public void open() {
        this.impl().open();
    }

    public void remove(JComponent jComponent) {
        this.impl().removeTab(jComponent);
    }

    public void requestActive() {
        this.impl().requestActive();
    }

    public void requestVisible() {
        this.impl().requestVisible();
    }

    public void select(JComponent jComponent) {
        this.impl().selectTab(jComponent);
    }

    public void setIcon(JComponent jComponent, Icon icon) {
        this.impl().setIcon(jComponent, icon);
    }

    public void setTitle(JComponent jComponent, String string) {
        this.impl().setTitle(jComponent, string);
    }

    public void setToolTipText(JComponent jComponent, String string) {
        this.impl().setToolTipText(jComponent, string);
    }

    public void setToolbarActions(JComponent jComponent, Action[] actionArray) {
        this.impl().setToolbarActions(jComponent, actionArray);
    }

    public boolean isCloseable(JComponent jComponent) {
        return true;
    }

    public static final class IOWindowImpl
    extends TopComponent
    implements ChangeListener,
    PropertyChangeListener {
        public static IOWindowImpl DEFAULT;
        private static final String ICON_PROP = "tabIcon";
        private static final String TOOLBAR_ACTIONS_PROP = "toolbarActions";
        private static final String TOOLBAR_BUTTONS_PROP = "toolbarButtons";
        private static final String ICON_RESOURCE = "org/netbeans/core/io/ui/output.png";
        private static final boolean AQUA;
        private JTabbedPane pane;
        private JComponent singleTab;
        private JToolBar toolbar;
        private JPopupMenu popupMenu;
        private Map<JComponent, IOContainer.CallBacks> tabToCb = new HashMap<JComponent, IOContainer.CallBacks>();
        boolean activated;
        JComponent lastSelTab;

        static synchronized IOWindowImpl findDefault() {
            if (DEFAULT == null) {
                TopComponent topComponent = WindowManager.getDefault().findTopComponent("output");
                if (topComponent != null) {
                    if (topComponent instanceof IOWindowImpl) {
                        DEFAULT = (IOWindowImpl)topComponent;
                    } else {
                        IllegalStateException illegalStateException = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected: " + IOWindowImpl.class.getName() + " Returned: " + topComponent.getClass().getName());
                        Logger.getLogger(IOWindowImpl.class.getName()).log(Level.WARNING, null, illegalStateException);
                        IOWindowImpl.getDefault();
                    }
                } else {
                    IOWindowImpl.getDefault();
                }
            }
            DEFAULT.getActionMap().remove("org.openide.actions.FindAction");
            return DEFAULT;
        }

        public static synchronized IOWindowImpl getDefault() {
            if (DEFAULT == null) {
                DEFAULT = new IOWindowImpl();
            }
            return DEFAULT;
        }

        public Object readResolve() throws ObjectStreamException {
            return IOWindowImpl.getDefault();
        }

        public IOWindowImpl() {
            this.pane = TabbedPaneFactory.createCloseButtonTabbedPane();
            this.pane.addChangeListener(this);
            this.pane.addPropertyChangeListener("close", this);
            this.setFocusable(true);
            this.toolbar = new ToolbarWithOverflow();
            this.toolbar.setOrientation(1);
            this.toolbar.setLayout(new BoxLayout(this.toolbar, 1));
            this.toolbar.setFloatable(false);
            Insets insets = this.toolbar.getMargin();
            JButton jButton = new JButton();
            jButton.setBorderPainted(false);
            jButton.setOpaque(false);
            jButton.setText(null);
            jButton.setIcon(new Icon(){

                @Override
                public int getIconHeight() {
                    return 16;
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                }
            });
            this.toolbar.add(jButton);
            Dimension dimension = jButton.getPreferredSize();
            Dimension dimension2 = new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
            this.toolbar.setMinimumSize(dimension2);
            this.toolbar.setPreferredSize(dimension2);
            this.toolbar.remove(jButton);
            this.setLayout(new BorderLayout());
            this.add(this.toolbar, "West");
            this.toolbar.setBorder(new VariableRightBorder(this.pane));
            this.toolbar.setBorderPainted(true);
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(new Close());
            this.popupMenu.add(new CloseAll());
            this.popupMenu.add(new CloseOthers());
            this.pane.addMouseListener((MouseListener)new MouseUtils.PopupMouseAdapter(){

                protected void showPopup(MouseEvent mouseEvent) {
                    IOWindowImpl.this.popupMenu.show((Component)((Object)IOWindowImpl.this), mouseEvent.getX(), mouseEvent.getY());
                }
            });
            this.pane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        IOWindowImpl.this.requestActive();
                    }
                }
            });
            String string = NbBundle.getMessage(IOWindow.class, (String)"LBL_IO_WINDOW");
            this.setDisplayName(string);
            this.setToolTipText(string);
            this.setName(string);
            this.setIcon(ImageUtilities.loadImage((String)ICON_RESOURCE));
            this.putClientProperty("SlidingName", this.getDisplayName());
            if (AQUA) {
                this.setBackground(UIManager.getColor("NbExplorerView.background"));
                this.setOpaque(true);
                this.toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
                this.pane.setBackground(UIManager.getColor("NbExplorerView.background"));
                this.pane.setOpaque(true);
            }
        }

        public String getShortName() {
            return NbBundle.getMessage(IOWindow.class, (String)"LBL_IO_WINDOW");
        }

        public void open() {
            if (!this.isOpened()) {
                super.open();
            }
        }

        public void requestActive() {
            super.requestActive();
            JComponent jComponent = this.getSelectedTab();
            if (jComponent != null) {
                jComponent.requestFocus();
            }
        }

        public void requestVisible() {
            if (!this.isShowing()) {
                super.requestVisible();
            }
        }

        public boolean isActivated() {
            return this.activated;
        }

        public void addTab(JComponent jComponent, IOContainer.CallBacks callBacks) {
            if (callBacks != null) {
                this.tabToCb.put(jComponent, callBacks);
            }
            if (this.singleTab != null) {
                assert (this.pane.getParent() == null);
                assert (this.pane.getTabCount() == 0);
                this.remove(this.singleTab);
                this.pane.add(this.singleTab);
                this.pane.setIconAt(0, (Icon)this.singleTab.getClientProperty(ICON_PROP));
                this.pane.setToolTipTextAt(0, this.singleTab.getToolTipText());
                this.singleTab = null;
                this.pane.add(jComponent);
                this.add(this.pane);
                this.updateWindowName(null);
            } else if (this.pane.getTabCount() > 0) {
                assert (this.pane.getParent() != null);
                assert (this.singleTab == null);
                this.pane.add(jComponent);
            } else {
                assert (this.pane.getParent() == null);
                assert (this.singleTab == null);
                this.setFocusable(false);
                this.singleTab = jComponent;
                this.add(jComponent);
                this.updateWindowName(this.singleTab.getName());
                this.checkTabSelChange();
            }
            this.revalidate();
        }

        public void removeTab(JComponent jComponent) {
            if (this.singleTab != null) {
                assert (this.singleTab == jComponent);
                this.remove(this.singleTab);
                this.singleTab = null;
                this.updateWindowName(null);
                this.checkTabSelChange();
                this.setFocusable(true);
                this.revalidate();
                this.repaint();
            } else if (this.pane.getParent() == this) {
                assert (this.pane.getTabCount() > 1);
                this.pane.remove(jComponent);
                if (this.pane.getTabCount() == 1) {
                    this.singleTab = (JComponent)this.pane.getComponentAt(0);
                    this.pane.remove(this.singleTab);
                    this.remove(this.pane);
                    this.add(this.singleTab);
                    this.updateWindowName(this.singleTab.getName());
                }
                this.revalidate();
            }
            IOContainer.CallBacks callBacks = this.tabToCb.remove(jComponent);
            if (callBacks != null) {
                callBacks.closed();
            }
        }

        public void selectTab(JComponent jComponent) {
            if (this.singleTab == null) {
                this.pane.setSelectedComponent(jComponent);
            }
            this.checkTabSelChange();
        }

        public JComponent getSelectedTab() {
            return this.singleTab != null ? this.singleTab : (JComponent)this.pane.getSelectedComponent();
        }

        public void setTitle(JComponent jComponent, String string) {
            jComponent.setName(string);
            if (this.singleTab != null) {
                assert (this.singleTab == jComponent);
                this.updateWindowName(string);
            } else {
                assert (this.pane.getParent() == this);
                int n = this.pane.indexOfComponent(jComponent);
                assert (n >= 0);
                this.pane.setTitleAt(n, string);
            }
        }

        public void setToolTipText(JComponent jComponent, String string) {
            jComponent.setToolTipText(string);
            if (this.singleTab != null) {
                assert (this.singleTab == jComponent);
            } else {
                assert (this.pane.getParent() == this);
                int n = this.pane.indexOfComponent(jComponent);
                assert (n >= 0);
                this.pane.setToolTipTextAt(n, string);
            }
        }

        public void setIcon(JComponent jComponent, Icon icon) {
            if (jComponent == this.singleTab) {
                jComponent.putClientProperty(ICON_PROP, icon);
                return;
            }
            int n = this.pane.indexOfComponent(jComponent);
            if (n < 0) {
                return;
            }
            jComponent.putClientProperty(ICON_PROP, icon);
            this.pane.setIconAt(n, icon);
            this.pane.setDisabledIconAt(n, icon);
        }

        void setToolbarActions(JComponent jComponent, Action[] actionArray) {
            if (actionArray != null && actionArray.length > 0) {
                jComponent.putClientProperty(TOOLBAR_ACTIONS_PROP, actionArray);
            }
            if (this.getSelectedTab() == jComponent) {
                this.updateToolbar(jComponent);
            }
        }

        public int getPersistenceType() {
            return 0;
        }

        public String preferredID() {
            return "output";
        }

        public void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (Boolean.TRUE.equals(this.getClientProperty("isSliding"))) {
                this.repaint(200L);
            }
        }

        public void paintComponent(Graphics graphics) {
            if (AQUA) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintComponent(graphics);
            if (this.hasFocus()) {
                Insets insets = this.getInsets();
                Color color = UIManager.getColor("controlShadow");
                if (color == null) {
                    color = Color.GRAY;
                }
                graphics.setColor(color);
                graphics.drawRect(insets.left + 2, insets.top + 2, this.getWidth() - (insets.left + insets.right + 4), this.getHeight() - (insets.top + insets.bottom + 4));
            }
        }

        void updateWindowName(String string) {
            String string2 = NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_IO_WINDOW");
            if (string != null) {
                String string3 = NbBundle.getMessage(IOWindowImpl.class, (String)"FMT_IO_WINDOW", (Object[])new Object[]{string2, string});
                if (string3.indexOf("<html>") != -1) {
                    string3 = "<html>" + string3.replace("<html>", "");
                    this.setHtmlDisplayName(string3);
                    this.setToolTipText(string3);
                } else {
                    this.setDisplayName(string3);
                    this.setHtmlDisplayName(null);
                    this.setToolTipText(string3);
                }
            } else {
                this.setDisplayName(string2);
                this.setToolTipText(string2);
                this.setHtmlDisplayName(null);
            }
        }

        private void updateToolbar(JComponent jComponent) {
            this.toolbar.removeAll();
            if (jComponent != null) {
                JButton[] jButtonArray = this.getTabButtons(jComponent);
                for (int i = 0; i < jButtonArray.length; ++i) {
                    this.toolbar.add(jButtonArray[i]);
                }
            }
            this.toolbar.validate();
            this.toolbar.repaint();
        }

        JButton[] getTabButtons(JComponent jComponent) {
            JButton[] jButtonArray = (JButton[])jComponent.getClientProperty(TOOLBAR_BUTTONS_PROP);
            if (jButtonArray != null) {
                return jButtonArray;
            }
            Action[] actionArray = (Action[])jComponent.getClientProperty(TOOLBAR_ACTIONS_PROP);
            if (actionArray == null) {
                return new JButton[0];
            }
            jButtonArray = new JButton[actionArray.length];
            for (int i = 0; i < jButtonArray.length; ++i) {
                jButtonArray[i] = new JButton(actionArray[i]);
                jButtonArray[i].setBorderPainted(false);
                jButtonArray[i].setOpaque(false);
                jButtonArray[i].setText(null);
                jButtonArray[i].putClientProperty("hideActionText", Boolean.TRUE);
                Object object = actionArray[i].getValue("SmallIcon");
                if (!(object instanceof Icon)) {
                    throw new IllegalStateException("No icon provided for " + actionArray[i]);
                }
                jButtonArray[i].setDisabledIcon(ImageUtilities.createDisabledIcon((Icon)((Icon)object)));
                String string = (String)actionArray[i].getValue("Name");
                String string2 = (String)actionArray[i].getValue("ShortDescription");
                String string3 = (String)actionArray[i].getValue("LongDescription");
                if (string == null) {
                    string = string2;
                }
                if (string3 == null) {
                    string3 = string2;
                }
                jButtonArray[i].getAccessibleContext().setAccessibleName(string);
                jButtonArray[i].getAccessibleContext().setAccessibleDescription(string3);
            }
            return jButtonArray;
        }

        protected void componentActivated() {
            super.componentActivated();
            this.activated = true;
            JComponent jComponent = this.getSelectedTab();
            IOContainer.CallBacks callBacks = this.tabToCb.get(jComponent);
            if (callBacks != null) {
                callBacks.activated();
            }
        }

        protected void componentDeactivated() {
            super.componentDeactivated();
            this.activated = false;
            JComponent jComponent = this.getSelectedTab();
            IOContainer.CallBacks callBacks = this.tabToCb.get(jComponent);
            if (callBacks != null) {
                callBacks.deactivated();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.checkTabSelChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("close".equals(propertyChangeEvent.getPropertyName())) {
                JComponent jComponent = (JComponent)propertyChangeEvent.getNewValue();
                this.removeTab(jComponent);
            }
        }

        void checkTabSelChange() {
            JComponent jComponent = this.getSelectedTab();
            if (jComponent != this.lastSelTab) {
                this.lastSelTab = jComponent;
                this.updateToolbar(jComponent);
                this.getActionMap().setParent(jComponent != null ? jComponent.getActionMap() : null);
            }
        }

        private JComponent[] getTabs() {
            if (this.singleTab != null) {
                return new JComponent[]{this.singleTab};
            }
            JComponent[] jComponentArray = new JComponent[this.pane.getTabCount()];
            for (int i = 0; i < this.pane.getTabCount(); ++i) {
                jComponentArray[i] = (JComponent)this.pane.getComponentAt(i);
            }
            return jComponentArray;
        }

        public TopComponent.SubComponent[] getSubComponents() {
            if (this.singleTab != null) {
                return new TopComponent.SubComponent[0];
            }
            JComponent[] jComponentArray = this.getTabs();
            TopComponent.SubComponent[] subComponentArray = new TopComponent.SubComponent[jComponentArray.length];
            for (int i = 0; i < subComponentArray.length; ++i) {
                final JComponent jComponent = jComponentArray[i];
                String string = this.pane.getTitleAt(i);
                subComponentArray[i] = new TopComponent.SubComponent(string, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (IOWindowImpl.this.singleTab != null || IOWindowImpl.this.pane.indexOfComponent(jComponent) < 0) {
                            return;
                        }
                        IOWindowImpl.this.selectTab(jComponent);
                    }
                }, jComponent == this.getSelectedTab());
            }
            return subComponentArray;
        }

        private void closeOtherTabs() {
            assert (this.pane.getParent() == this);
            JComponent jComponent = this.getSelectedTab();
            for (JComponent jComponent2 : this.getTabs()) {
                if (jComponent2 == jComponent) continue;
                this.removeTab(jComponent2);
            }
        }

        private void closeAllTabs() {
            for (JComponent jComponent : this.getTabs()) {
                this.removeTab(jComponent);
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.core.io.ui.IOWindow");
        }

        static {
            AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
        }

        private class VariableRightBorder
        implements Border {
            private JTabbedPane pane;

            public VariableRightBorder(JTabbedPane jTabbedPane) {
                this.pane = jTabbedPane;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                if (this.pane.getParent() != IOWindowImpl.this) {
                    Color color = graphics.getColor();
                    graphics.setColor(this.getColor());
                    graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
                    graphics.setColor(color);
                }
            }

            public Color getColor() {
                if (Utilities.isMac()) {
                    Color color = UIManager.getColor("controlShadow");
                    Color color2 = UIManager.getColor("control");
                    return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
                }
                return UIManager.getColor("controlShadow");
            }

            @Override
            public Insets getBorderInsets(Component component) {
                if (this.pane.getParent() == IOWindowImpl.this) {
                    return new Insets(0, 0, 0, 0);
                }
                return new Insets(0, 0, 0, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }
        }

        private class CloseOthers
        extends AbstractAction {
            public CloseOthers() {
                super(NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_CloseOthers"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IOWindowImpl.this.closeOtherTabs();
            }
        }

        private class CloseAll
        extends AbstractAction {
            public CloseAll() {
                super(NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_CloseAll"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IOWindowImpl.this.closeAllTabs();
            }
        }

        private class Close
        extends AbstractAction {
            public Close() {
                super(NbBundle.getMessage(IOWindowImpl.class, (String)"LBL_Close"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IOWindowImpl.this.removeTab(IOWindowImpl.this.getSelectedTab());
            }
        }
    }
}

