/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import java.io.UnsupportedEncodingException;

final class StringParser
implements IParser {
    public static final StringParser INSTANCE = new StringParser();
    private static final String CHARSET = "UTF-16";
    private static final int UNREASONABLE_STRING_LENGTH = 10000000;

    StringParser() {
    }

    @Override
    public Object read(byte[] data, Offset offset) throws InvalidFlrFileException {
        int index = offset.get();
        int byteCount = StringParser.readStringByteCount(data, index);
        offset.increase(4 + byteCount);
        try {
            return new String(data, index + 4, byteCount, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readStringByteCount(byte[] data, int offset) throws InvalidFlrFileException {
        int stringLength = IntegerParser.readInt(data, offset);
        if (stringLength < 0 || stringLength > 10000000) {
            throw new InvalidFlrFileException();
        }
        return stringLength * 2;
    }
}

